﻿
#ifndef IOT_Drone_h
#define IOT_Drone_h

#include "Arduino.h"

//------------------------------------------------------------------------------------//

#define SEND_SERIAL_HW		0
#define SEND_SERIAL_SOFT	1
#define SEND_SERIAL_ALL		2

//------------------------------------------------------------------------------------//
void set_serial(byte sendSerial);

bool begin_serial(Stream& stream);
void send_write(unsigned char data[],int length);
void send_byte(unsigned char data);
//------------------------------------------------------------------------------------//

//------------------------------------------------------------------------------------//
void RFsendProcess(byte selectSerial, byte _cType, byte _length, byte _from, byte _to...);
//void RFsendProcess(byte _cType, byte _length, byte _from, byte _to...);

void moveBasedPowerAndRequestData(int _roll, int _pitch, int _yaw, int _throttle);
void moveBasedPower(int _roll, int _pitch, int _yaw, int _throttle);

void flightEvent(byte _event);
void requestAttitude(int _roll, int _pitch, int _yaw);
void requestMotion(int _accX, int _accY, int _accZ, int _gyroX, int _gyroY, int _gyroZ, int _roll, int _pitch, int _yaw);

void requestAll(byte _accX, byte _accY, byte _accZ, int _roll, int _pitch, int _yaw, int _left_x, int _left_y, int _right_x, int _right_y, byte but, byte micLV, byte batPercent);


unsigned short CRC16_Make(unsigned char *buf, int len); //CRC16-CCITT Format
boolean CRC16_Check(unsigned char data[], int len, unsigned char crc[]);

//------------------------------------------------------------------------------------//

void BTsendProcess(byte dataL, byte dataR, byte data);
void BTstart();




//------------------------------------------------------------------------------------//


enum DataType
{
  TypeNone                    = 0x00,     // 없음
  Ping                        = 0x01,     // 통신 확인
  Ack                         = 0x02,     // 데이터 수신에 대한 응답
  Error                       = 0x03,     // 오류(reserve, 비트 플래그는 추후에 지정)
  Request                     = 0x04,     // 지정한 타입의 데이터 요청
  Message                     = 0x05,     // 문자열 데이터
  Address                     = 0x06,     // 장치 주소(MAC이 있는 경우 MAC) 혹은 고유번호(MAC이 없는 경우 UUID)
  Information                 = 0x07,     // 펌웨어 및 장치 정보
  Update                      = 0x08,     // 펌웨어 업데이트
  UpdateLocation              = 0x09,     // 펌웨어 업데이트 위치 정정
  Encrypt                     = 0x0A,     // 펌웨어 암호화
  SystemCount                 = 0x0B,     // 시스템 카운트
  SystemInformation           = 0x0C,     // 시스템 정보
  Registration                = 0x0D,     // 제품 등록(암호화 데이터 및 등록 데이터를 데이터 길이로 구분)
  Administrator               = 0x0E,     // 관리자 권한 획득
  Monitor                     = 0x0F,     // 디버깅용 값 배열 전송. 첫번째 바이트에 타입, 두 번째 바이트에 페이지 지정(수신 받는 데이터의 저장 경로 구분)
  Control                     = 0x10,     // 조종

  Command                     = 0x11,     // 명령
  Pairing                     = 0x12,     // 페어링
  Rssi                        = 0x13,     // RSSI

  // Light
  LightManual                 = 0x20,     // LED 수동 제어
  LightMode                   = 0x21,     // LED 모드 지정
  LightEvent                  = 0x22,     // LED 이벤트
  LightDefault                = 0x23,     // LED 기본 색상

  // 센서 RAW 데이터
  RawMotion                   = 0x30,     // Motion 센서 데이터 RAW 값
  RawFlow,                                // Flow 센서 데이터 RAW 값

  // 상태,  센서
  State                       = 0x40,     // 드론의 상태(비행 모드, 방위기준, 배터리량)
  Attitude,                               // 드론의 자세(Angle)(Attitude)
  Position,                               // 위치
  Altitude,                               // 높이, 고도
  Motion,                                 // Motion 센서 데이터 처리한 값(IMU)
  Range,                                  // 거리센서 데이터

  // 설정
  Count                       = 0x50,     // 카운트
  Bias,                                   // 엑셀, 자이로 바이어스 값
  Trim,                                   // 트림
  Weight,                                 // 무게 설정
  SetLostConnection,                         // 연결이 끊긴 후 반응 시간 설정

  // Devices
  Motor                       = 0x60,     // 모터 제어 및 현재 제어값 확인
  MotorSingle,                            // 한 개의 모터 제어
  Buzzer,                                 // 부저 제어
  Vibrator,                               // 진동 제어

  // Input
  Button                      = 0x70,     // 버튼 입력
  Joystick,                               // 조이스틱 입력

  // Display
  DisplayClear                = 0x80,     // 화면 지우기
  DisplayInvert,                          // 화면 반전
  DisplayDrawPoint,                       // 점 그리기
  DisplayDrawLine,                        // 선 그리기
  DisplayDrawRect,                        // 사각형 그리기
  DisplayDrawCircle,                      // 원 그리기
  DisplayDrawString,                      // 문자열 쓰기
  DisplayDrawStringAlign,                 // 문자열 쓰기
  DisplayDrawImage,                       // 그림 그리기

  // Information Assembled
  InformationAssembledForController       = 0xA0,     // 자주 갱신되는 비행 데이터 모음
  InformationAssembledForEntry            = 0xA1,     // 자주 갱신되는 비행 데이터 모음

  // Navigation
  NavigationTarget                        = 0xD0,     // 네비게이션 목표점
  NavigationLocation                      = 0xD1,     // 네비게이션 가상 위치
  NavigationMonitor                       = 0xD2,
  NavigationHeading                       = 0xD3,
  NavigationCounter                       = 0xD4,

  GpsRtkNavigationState                   = 0xDA,     // RTK RAW 데이터 전송
  GpsRtkExtendedRawMeasurementData        = 0xDB,     // RTK RAW 데이터 전송
};

//----------------------------------------------------------------------------------------------------------------------------//

enum FlightEvent
{
  FlightNone  = 0,        

  Stop        = 0x10,    
  TakeOff,               
  Landing,               

  Reverse,               

  FlipFront,             
  FlipRear,             
  FlipLeft,               // 회전
  FlipRight,              // 회전

  Return,                 // 시작 위치로 돌아가기

  ResetHeading = 0xA0,    // 헤딩 리셋(Headless 모드 일 때 현재 heading을 0도로 변경)
};

//----------------------------------------------------------------------------------------------------------------------------//

enum LedMode
{
  RearNone = 0x10,
  RearManual,             // 수동 제어
  RearHold,               // 지정한 색상을 계속 켬
  RearFlicker,            // 깜빡임
  RearFlickerDouble,      // 깜빡임(두 번 깜빡이고 깜빡인 시간만큼 꺼짐)
  RearDimming,            // 밝기 제어하여 천천히 깜빡임

  BodyNone = 0x20,
  BodyManual,             // 수동 제어
  BodyHold,               // 지정한 색상을 계속 켬
  BodyFlicker,            // 깜빡임
  BodyFlickerDouble,      // 깜빡임(두 번 깜빡이고 깜빡인 시간만큼 꺼짐)
  BodyDimming,            // 밝기 제어하여 천천히 깜빡임
  BodySunrise,            // 꺼진 상태에서 점점 밝아짐
  BodySunset,             // 켜진 상태에서 점점 어두워짐

  ANone = 0x30,
  AManual,                // 수동 제어
  AHold,                  // 지정한 색상을 계속 켬
  AFlicker,               // 깜빡임
  AFlickerDouble,         // 깜빡임(두 번 깜빡이고 깜빡인 시간만큼 꺼짐)
  ADimming,               // 밝기 제어하여 천천히 깜빡임

  BNone = 0x40,
  BManual,                // 수동 제어
  BHold,                  // 지정한 색상을 계속 켬
  BFlicker,               // 깜빡임
  BFlickerDouble,         // 깜빡임(두 번 깜빡이고 깜빡인 시간만큼 꺼짐)
  BDimming,               // 밝기 제어하여 천천히 깜빡임

  CNone = 0x50,
  CManual,                // 수동 제어
  CHold,                  // 지정한 색상을 계속 켬
  CFlicker,               // 깜빡임
  CFlickerDouble,         // 깜빡임(두 번 깜빡이고 깜빡인 시간만큼 꺼짐)
  CDimming,               // 밝기 제어하여 천천히 깜빡임
};



enum Colors
{
  AliceBlue, AntiqueWhite, Aqua,
  Aquamarine, Azure, Beige,
  Bisque, Black, BlanchedAlmond,
  Blue, BlueViolet, Brown,
  BurlyWood, CadetBlue, Chartreuse,
  Chocolate, Coral, CornflowerBlue,
  Cornsilk, Crimson, Cyan,
  DarkBlue, DarkCyan, DarkGoldenRod,
  DarkGray, DarkGreen, DarkKhaki,
  DarkMagenta, DarkOliveGreen, DarkOrange,
  DarkOrchid, DarkRed, DarkSalmon,
  DarkSeaGreen, DarkSlateBlue, DarkSlateGray,
  DarkTurquoise, DarkViolet, DeepPink,
  DeepSkyBlue, DimGray, DodgerBlue,
  FireBrick, FloralWhite, ForestGreen,
  Fuchsia, Gainsboro, GhostWhite,
  Gold, GoldenRod, Gray,
  Green, GreenYellow, HoneyDew,
  HotPink, IndianRed, Indigo,
  Ivory, Khaki, Lavender,
  LavenderBlush, LawnGreen, LemonChiffon,
  LightBlue, LightCoral, LightCyan,
  LightGoldenRodYellow, LightGray, LightGreen,
  LightPink, LightSalmon, LightSeaGreen,
  LightSkyBlue, LightSlateGray, LightSteelBlue,
  LightYellow, Lime, LimeGreen,
  Linen, Magenta, Maroon,
  MediumAquaMarine, MediumBlue, MediumOrchid,
  MediumPurple, MediumSeaGreen, MediumSlateBlue,
  MediumSpringGreen, MediumTurquoise, MediumVioletRed,
  MidnightBlue, MintCream, MistyRose,
  Moccasin, NavajoWhite, Navy,
  OldLace, Olive, OliveDrab,
  Orange, OrangeRed, Orchid,
  PaleGoldenRod, PaleGreen, PaleTurquoise,
  PaleVioletRed, PapayaWhip, PeachPuff,
  Peru, Pink, Plum,
  PowderBlue, Purple, RebeccaPurple,
  Red, RosyBrown, RoyalBlue,
  SaddleBrown, Salmon, SandyBrown,
  SeaGreen, SeaShell, Sienna,
  Silver, SkyBlue, SlateBlue,
  SlateGray, Snow, SpringGreen,
  SteelBlue, Tan, Teal,
  Thistle, Tomato, Turquoise,
  Violet, Wheat, White,
  WhiteSmoke, Yellow, YellowGreen,
  EndOfColor
};


enum ErrorFlagsForSensor
{
  ErrorSensorNone                         = 0x00000000,

  Motion_NoAnswer                         = 0x00000001,   // Motion 응답 없음
  Motion_WrongValue                       = 0x00000002,   // Motion 잘못된 값
  Motion_NotCalibrated                    = 0x00000004,   // Gyro Bias 보정이 완료되지 않음
  Motion_Calibrating                      = 0x00000008,   // Gyro Bias 보정 중

  Pressure_NoAnswer                       = 0x00000010,   // 압력 센서 응답 없음
  Pressure_WrongValue                     = 0x00000020,   // 압력 센서 잘못된 값

  RangeGround_NoAnswer                    = 0x00000100,   // 바닥 거리 센서 응답 없음
  RangeGround_WrongValue                  = 0x00000200,   // 바닥 거리 센서 잘못된 값

  Flow_NoAnswer                           = 0x00001000,   // Flow 응답 없음
  Flow_WrongValue                         = 0x00002000,   // Flow 잘못된 값
  Flow_CannotRecognizeGroundImage         = 0x00004000,   // 바닥 이미지를 인식할 수 없음
};

enum ErrorFlagsForState
{
  ErrorStateNone                          = 0x00000000,

  NotRegistered                           = 0x00000001,   // 장치 등록이 안됨
  FlashReadLock_UnLocked                  = 0x00000002,   // 플래시 메모리 읽기 Lock이 안 걸림
  BootloaderWriteLock_UnLocked            = 0x00000004,   // 부트로더 영역 쓰기 Lock이 안 걸림

  TakeoffFailure_CheckPropellerAndMotor   = 0x00000010,   // 이륙 실패
  CheckPropellerVibration                 = 0x00000020,   // 프로펠러 진동발생
  Attitude_NotStable                      = 0x00000040,   // 자세가 많이 기울어져 있거나 뒤집어져 있을때

  CanNotFlip_LowBattery                   = 0x00000100,   // 배터리가 30이하
  CanNotFlip_TooHeavy                     = 0x00000200,   // 기체가 무거움

};


enum LightFlagType
{
  LightFlagNone        = 0x0000,

  Rear        = 0x0001,
  BodyRed     = 0x0002,
  BodyGreen   = 0x0004,
  BodyBlue    = 0x0008,

  A_LED       = 0x0010,
  B_LED       = 0x0020,
  CRed        = 0x0040,
  CGreen      = 0x0080,
  CBlue       = 0x0100,
};


enum DeviceType
{
  //  None        = 0x00,

  Drone       = 0x10,     // 드론(Server)

  Controller  = 0x20,     // 조종기(Client)

  LinkClient  = 0x30,     // 링크 모듈(Client)
  LinkServer  = 0x31,     // 링크 모듈(Server)
  BleClient   = 0x32,     // BLE 클라이언트
  BleServer   = 0x33,     // BLE 서버

  RangeModule  = 0x40,     // 거리 센서 모듈

  Base        = 0x70,     // 베이스

  ByScratch   = 0x80,     // 바이스크래치
  Scratch     = 0x81,     // 스크래치
  Entry       = 0x82,     // 네이버 엔트리

  Tester      = 0xA0,     // 테스터
  // Monitor     = 0xA1,     // 모니터
  Updater     = 0xA2,     // 펌웨어 업데이트 도구
  Encrypter   = 0xA3,     // 암호화 도구

  // EndOfType,

  Whispering      = 0xFE, // 바로 인접한 장치까지만 전달(받은 장치는 자기 자신에게 보낸 것처럼 처리하고 타 장치에 전달하지 않음)
  Broadcasting    = 0xFF  // 연결된 모든 장치에 전달
};


#endif