﻿
#ifndef IOT_LED_h
#define IOT_LED_h
#include <Adafruit_NeoPixel.h>

//------------------------------------------------------------------------------------//

#define NEOPIXEL_PIN  6

//------------------------------------------------------------------------------------//
#define MAIN_NUMPIXELS    12
//------------------------------------------------------------------------------------//
#define LEFT_ANALOG_PIN0  A2
#define LEFT_ANALOG_PIN1  A3
#define LEFT_INPUT_PIN    4 // PULLUP
#define LEFT_OUT_PIN      5 // LED
#define LEFT_NUMPIXELS    3
//------------------------------------------------------------------------------------//
#define RIGHT_ANALOG_PIN0  A0
#define RIGHT_ANALOG_PIN1  A1
#define RIGHT_INPUT_PIN    9 // PULLUP
#define RIGHT_OUT_PIN      10 // LED
#define RIGHT_NUMPIXELS    3
//------------------------------------------------------------------------------------//


//------------------------------------------------------------------------------------//

void LEDPixelSet_Main(byte select, byte r, byte g, byte b);
void LEDPixelSet_Left(byte select, byte r, byte g, byte b);
void LEDPixelSet_Right(byte select, byte r, byte g, byte b);
void LEDShow_Main();
void LEDShow_Left();
void LEDShow_Right();

void NeoPixelInit();
void MainNeoPixelsTest();
uint32_t Wheel(byte WheelPos);
void colorWipe(uint32_t c, uint8_t wait);
void rainbow(uint8_t wait);
void rainbowCycle(uint8_t wait);
void theaterChase(uint32_t c, uint8_t wait);
void theaterChaseRainbow(uint8_t wait);

#endif