#include "Zumi.h"

float targetAngle = 0;

void setup()
{
  Serial.begin(57600);
  Zumi.MotorInit();
  Zumi.IRsensorInit();
  Zumi.GyroCalibration();

  while (!Zumi.getGyro());
  targetAngle = Zumi.eulerAngle(YAW);
}

void loop()
{
  while (!Zumi.getGyro());

  byte sensorFR = Zumi.readIR(RIGHT_FRONT_IR, true);
  byte sensorFL = Zumi.readIR(LEFT_FRONT_IR, true);

  if (sensorFL < 100 or sensorFR < 100)
  {
    Zumi.moveTurn(right, 90);

    targetAngle += 90;
    if (targetAngle == 360)
      targetAngle = 0;
  }
  else
  {
    Zumi.moveContinuousAngle(30, targetAngle);
  }
}
