
Process.prototype.exData = function() {
  exAnalogPin = undefined;
  exAnalogValue = undefined;
  exDigitalPin  = undefined;
  exDigitalValue = undefined;
  exDigitalInputValue = undefined;
  exMotorPin = undefined;
  exMotorDir = undefined;
  exMotorSpeed = undefined;
  sevenSensorValue = undefined;
  batteryRemnant = undefined;
  exLinkyMotorDir = undefined;
  exLinkyMotorSpeed = undefined;
  exLedColorRGB = undefined;
  exBuzzData = undefined;

  //exIRRemoconValue = 0xFF;
};

Process.prototype.packetTable = {
  setServo : int = 0,
  setAnalogPin : int = 1,
  setDigitalPin : int = 2,
  setDCMotor  : int = 3,
  setDigitalReading : int = 4,
  sevenSensor : int = 5,
  //for Linky
  ledColor : int = 6,
  LinkySetDCmotor : int = 7,
  buzzer : int = 8,

  enableNum_1 : int = 1,
  enableNum_2 : int = 2,
  enableNum_3 : int = 3,
  enableNum_4 : int = 4,
  enableNum_5 : int = 5,
}

Process.prototype.pitchData = {
    'NOTE_C2' : 65,
    'NOTE_CS2' :69,
    'NOTE_D2' : 73,
    'NOTE_DS2' : 78,
    'NOTE_E2' : 82,
    'NOTE_F2' : 87,
    'NOTE_FS2' : 93,
    'NOTE_G2' : 98,
    'NOTE_GS2' : 104,
    'NOTE_A2' : 110,
    'NOTE_AS2' : 117,
    'NOTE_B2' : 123,
    'NOTE_C3' : 131,
    'NOTE_CS3' : 139,
    'NOTE_D3' : 147,
    'NOTE_DS3' : 156,
    'NOTE_E3' : 165,
    'NOTE_F3' : 175,
    'NOTE_FS3' : 185,
    'NOTE_G3' : 196,
    'NOTE_GS3' : 208,
    'NOTE_A3' : 220,
    'NOTE_AS3' : 233,
    'NOTE_B3' : 247,
    'NOTE_C4' : 262,
    'NOTE_CS4' : 277,
    'NOTE_D4' : 294,
    'NOTE_DS4' : 311,
    'NOTE_E4' : 330,
    'NOTE_F4' : 349,
    'NOTE_FS4' : 370,
    'NOTE_G4' : 392,
    'NOTE_GS4' : 415,
    'NOTE_A4' : 440,
    'NOTE_AS4' : 466,
    'NOTE_B4' : 494,
}


Process.prototype.inputDataInit = function() {
  var myself = this;

  myself.exData.exDigitalInputValue = {};

  for(var i = 0; i < 32; i++) {
    myself.exData.exDigitalInputValue[i] = true;        // pin input status (HIGH/LOW)

  }
}

Process.prototype.exDataInit = function() {
  var myself = this;

  myself.exData.exAnalogValue = {};
  myself.exData.exLinkyMotorDir = {};
  myself.exData.exLinkyMotorSpeed = {};
  myself.exData.exLedColorRGB = {};
  myself.exData.exBuzzData = {};

  for(var i = 0; i < 10; i++) {
    myself.exData.exAnalogValue[i] = -1;
    myself.exData.exLinkyMotorDir[i] = 0;
    myself.exData.exLinkyMotorSpeed[i] = 0;
  }

  myself.exData.batteryRemnant = -1;
  myself.exData.exLedColorRGB[0] = 0;
  myself.exData.exLedColorRGB[1] = 0;
  myself.exData.exLedColorRGB[2] = 0;
  myself.exData.exBuzzData[0] = 0;
  myself.exData.exBuzzData[1] = 0;
  myself.exData.exBuzzData[2] = 0;
}

// ---------------for Linky blocks------------------------
Process.prototype.LinkySensorReading = function (pin) {
    var sprite = this.homeContext.receiver;
    var adc = -1;
    //console.log("SPRITE: " + sprite);
    if (sprite.isBoardReady()) {
      switch(pin[0]) {
          case 'A0': adc = 0; break;
          case 'A1': adc = 1; break;
          case 'A2': adc = 2; break;
          case 'A3': adc = 3; break;
          case 'A4': adc = 4; break;
      }

     if((adc >= 0)&&(adc < 5)) return sprite.rokit.readValue[adc];
     return 0;

    } else {
        throw new Error(localize("Linky not connected"));
    }
}

Process.prototype.LinkyIRRemocon = function () {
    var sprite = this.homeContext.receiver;

    if (sprite.isBoardReady()) {
      return sprite.rokit.IRRemocon;
    } else {
        throw new Error(localize("Linky not connected"));
    }
}

Process.prototype.batterycheck = function () {
    var sprite = this.homeContext.receiver;
    var myself = this;

    if (sprite.isBoardReady()) {
     return sprite.rokit.battery;

    } else {
        throw new Error(localize("Linky not connected"));
    }
}

Process.prototype.micInput = function () {
    var sprite = this.homeContext.receiver;
    var myself = this;

    if (sprite.isBoardReady()) {
      return sprite.rokit.micInput;

    } else {
        throw new Error(localize("Linky not connected"));
    }
}

Process.prototype.LinkySetDCmotor = function (num, speed, dir) {
    var sprite = this.homeContext.receiver;
    var myself = this;
    var motorNumber = 0;
    var direction = 0;
    console.log(num[0] + "  " + speed + "  " + dir[0]);
    if (sprite.isBoardReady()) {

      switch(num[0]) {
          case 'M1': motorNumber = 0; break;
          case 'M2': motorNumber = 1; break;
      }
      switch(dir[0]) {
          case 'CW': direction = 1; break;
          case 'CCW': direction = 2; break;
          case 'STOP': direction = 3; break;
          case 'LOOSE': direction = 4; break;
      }

      if((num[0] != undefined)&&(dir[0] != undefined)) {
        sprite.param.motorDir[motorNumber] = direction;
        if((motorNumber == 2)&&(speed < 5)) speed = 5;  //fot firmata Bug

        if((speed >= 0)&&(speed <= 100)) sprite.param.motorSpeed[motorNumber] = speed;
        else sprite.param.motorSpeed[motorNumber] = 0;
        sprite.enable.DCMotorSendEn[motorNumber] = sprite.number.once;
      }
    } else {
        throw new Error(localize("Linky not connected"));
    }
}

Process.prototype.LinkyBuzz = function (pitch, dur) {
    var sprite = this.homeContext.receiver;
    var myself = this;
    var duration = 0;
    console.log(pitch[0] + " " + dur[0]);
    //console.log(myself.pitchData[pitch[0]]);
    if (sprite.isBoardReady()) {
      switch(dur[0]) {
          case 'WHOLE_NOTE': duration  = 250; break;
          case 'HALF_NOTE': duration  = 125; break;
          case 'QUARTER_NOTE': duration = 62; break;
          case 'EIGHTH_NOTE': duration = 31; break;
          case 'SIXTEENTH_NOTE': duration = 16; break;
      }
      if((pitch[0] != undefined)&&(dur[0] != undefined)) {
        var pitchValue = myself.pitchData[pitch[0]];
        sprite.param.buzzData[0] = pitchValue & 0xFF;
        sprite.param.buzzData[1] = (pitchValue & 0xFF00) >> 8;
        sprite.param.buzzData[2] = duration & 0xFF;
        sprite.enable.buzzerSendEn =  sprite.number.once;
      }
      //console.log(sprite.param.buzzData[0] + " " + sprite.param.buzzData[1] + " " + sprite.param.buuzzData[2]);
    } else {
        throw new Error(localize("Linky not connected"));
    }
}

Process.prototype.ledColor = function (color, status) {
    var sprite = this.homeContext.receiver;
    var myself = this;
    var motorNumber = 0;
    var direction = 0;
    console.log(color.r + " " + color.g + " " + color.b + " " + status);
    if (sprite.isBoardReady()) {
      if(status[0] == 'ON') {
        sprite.param.ledColorRGB[0] = Math.round(color.r * 0.392);
        sprite.param.ledColorRGB[1] = Math.round(color.g * 0.392);
        sprite.param.ledColorRGB[2] = Math.round(color.b * 0.392);
        if(sprite.param.ledColorRGB[0] == 0xFF) sprite.param.ledColorRGB[0] = 0xFE;
        if(sprite.param.ledColorRGB[1] == 0xFF) sprite.param.ledColorRGB[0] = 0xFE;
        if(sprite.param.ledColorRGB[2] == 0xFF) sprite.param.ledColorRGB[0] = 0xFE;
        sprite.param.ledColorOnOff = 1;
        sprite.enable.LEDColorSendEn = sprite.number.once;
        console.log("color: " + sprite.param.ledColorRGB[0] + " " + sprite.param.ledColorRGB[1] + " " + sprite.param.ledColorRGB[2]);
      }
      else {
        sprite.param.ledColorRGB[0] = 0;
        sprite.param.ledColorRGB[1] = 0;
        sprite.param.ledColorRGB[2] = 0;
        sprite.param.ledColorOnOff = 0;
        sprite.enable.LEDColorSendEn = sprite.number.once;
      }

    } else {
        throw new Error(localize("Linky not connected"));
    }
}

Process.prototype.linetracing = function (spd) {
  var sprite = this.homeContext.receiver;
  var myself = this;
  console.log("speed" + spd);
  if (sprite.isBoardReady()) {
    sprite.enable.linetracingSendEn =  sprite.number.once;
    if((spd >= 0)&&(spd <= 100)) sprite.param.linetracingData[0] = spd;
  } else {
      throw new Error(localize("Linky not connected"));
  }
}
