// init decorator

SpriteMorph.prototype.originalInit = SpriteMorph.prototype.init;
SpriteMorph.prototype.init = function(globals) {
    var myself = this;
    myself.originalInit(globals);

    var valArr = new Array();
    var valArr = [0,1,2,3,4,5,6,7,8,9];
    const myVersion = 1.26;
    const linkyVersion = 0.3;
    const inventorVersion = 1.2;

 this.rokit = {
   robot : undefined,
   firmAlert : false,
   connectingStatus : int = 0,
   scratchStatus : int = 0,
   temp : int = 0,
   battery : float = 0,
   micInput : int = 0,
   IRRemocon : int = 0,
   version : float = 0,
   sevenSensor : int = 0,
   portList : new Array(),
   usedPort : new Array(),
   hardware : int = -1,
   readValue : undefined,
   dataReady : undefined,
   inputPinValue : undefined,
   loopExit : false,
   sendCounter : int = 0,
   receivingCheck: int = 0,
   rqstCheck : int = 0,
   exRqstCheck : int = 0,
   intervalCheck : int = 0,
   closingMsg : undefined,
   isChildOpen : false,
   countPoll : int = 0,
   linkyHex : undefined,
   inventorHex : undefined
 };

 this.msg = {
   streamingSuccessMsg : false,
 }

 this.version = {
   linky: undefined,
   inventor: undefined,
   helperapp : undefined
 }

 this.exVersion = {
   linky: undefined,
   inventor: undefined,
   helperapp : undefined
 }

 this.updateSchedule = {
   linkyFirmware: false,
   inventorFirmware : false,
   helperapp : false
 }

 this.portStatus = {
   waitingPortConnect : int = 0,
   tryPortConnect : int = 1,
   successPortConnect : int = 2,
   tryDataStreaming : int = 3,
   successDataStreaming : int = 4,
   failedDataStreaming : int = 5
 };


 this.board = {
   nothing : int = -1,
   linky : int = 0,
   inventor : int = 1
 };

 this.dataStatus = {
   IRSensor : int = 13,
   volt : int = 14,
   etc : int = 15
 };

 this.inventorDataStatus = {
   adc0 : int = 0,
   adc1 : int = 1,
   adc2 : int = 2,
   adc3 : int = 3,
   adc4 : int = 4,
   adc5 : int = 5,
   adc6 : int = 6,
   adc7 : int = 7,
   pinStatus : int = 8,
   sevenSensor : int = 10
 };

 this.command = {
   LEDColor : int = 0,
   DCMotor : int = 1,
   buzzer : int = 2,
   linetracing : int = 3,
   setServo : int = 4,
   setPin : int = 5,
   setPwm : int = 6,
   digitalWrite : int = 7
 };

 this.enable = {
   LEDColorSendEn : int = 0,
   DCMotorSendEn : undefined,
   buzzerSendEn : int = 0,
   linetracingSendEn :int = 0,
 };

 this.number = {
   once : int = 1,
   twice : int = 2,
   thirdTimes : int =3
 }

 this.param = {
   ledColorRGB : undefined,
   ledColorOnOff : undefined,
   motorDir : undefined,
   motorSpeed : undefined,
   buzzData : undefined,
   linetracingData : undefined,
   servoAngle : undefined,
   setPin : undefined,
   pwmValue : undefined,
   digitalWrite : undefined,
 };

 this.pitchData = {
   'C2' : 65,
   'CS2' :69,
   'D2' : 73,
   'DS2' : 78,
   'E2' : 82,
   'F2' : 87,
   'FS2' : 93,
   'G2' : 98,
   'GS2' : 104,
   'A2' : 110,
   'AS2' : 117,
   'B2' : 123,
   'C3' : 131,
   'CS3' : 139,
   'D3' : 147,
   'DS3' : 156,
   'E3' : 165,
   'F3' : 175,
   'FS3' : 185,
   'G3' : 196,
   'GS3' : 208,
   'A3' : 220,
   'AS3' : 233,
   'B3' : 247,
   'C4' : 262,
   'CS4' : 277,
   'D4' : 294,
   'DS4' : 311,
   'E4' : 330,
   'F4' : 349,
   'FS4' : 370,
   'G4' : 392,
   'GS4' : 415,
   'A4' : 440,
   'AS4' : 466,
   'B4' : 494,
 };

 myself.bufferInit = function() {
  var myself = this;
  console.log("clear buffer!");

  myself.rokit.readValue = {};
  myself.rokit.dataReady = {};

  for(var i = 0; i < 11; i++) {
    myself.rokit.readValue[i] = 0;
    myself.rokit.dataReady[i] = false;
  }

  myself.rokit.closingMsg = "";

  myself.enable.LEDColorSendEn = 0;
  myself.enable.DCMotorSendEn = {};
  myself.enable.DCMotorSendEn[0] = 0;
  myself.enable.DCMotorSendEn[1] = 0;

  myself.param.ledColorRGB = {};
  myself.param.ledColorOnOff = 0;
  myself.param.motorDir = {};
  myself.param.motorSpeed  = {};
  myself.param.buzzData = {};
  myself.param.linetracingData = {};

  myself.param.motorDir[0] = 0;
  myself.param.motorDir[1] = 0;
  myself.param.motorSpeed[0] = 0;
  myself.param.motorSpeed[1] = 0;

  myself.param.ledColorRGB[0] = 0;
  myself.param.ledColorRGB[1] = 0;
  myself.param.ledColorRGB[2] = 0;
  myself.param.buzzData[0] = 0;
  myself.param.buzzData[1] = 0;
  myself.param.buzzData[2] = 0;

  myself.param.linetracingData[0]  = 0;

}

console.log("start!");
myself.bufferInit();

 myself.packetHandler = function(stat) {
     var myself = this;
     var temp = 0, i = 0, pointer = 0, category = 0;
     console.log("packetHandler: " + stat);
     if(stat == true)  myself.packetHandler.sender = setInterval(function() {

       myself.rokit.loopExit = false;

       while(myself.rokit.loopExit == false) {

         if(myself.rokit.sendCounter == 0)   category =  myself.command.LEDColor;
         else if((myself.rokit.sendCounter >= 1)&&(myself.rokit.sendCounter < 3)) category = myself.command.DCMotor;
         else if(myself.rokit.sendCounter == 3) category =  myself.command.buzzer;
         else if(myself.rokit.sendCounter == 4) category = myself.command.linetracing;
         pointer = myself.rokit.sendCounter;

         switch(category) {

           case myself.command.LEDColor:
             if( myself.enable.LEDColorSendEn > 0 ) {
                 myself.enable.LEDColorSendEn--;

                 if(myself.rokit.hardware == myself.board.linky) {
                   if(myself.param.ledColorOnOff == 0) { myself.param.ledColorRGB[0] = 0; myself.param.ledColorRGB[1] = 0; myself.param.ledColorRGB[2] = 0;}
                   myself.rokit.robot.write(new Buffer([0xFF, 0XFF, 0x04, 0x0E, myself.param.ledColorRGB[0], myself.param.ledColorRGB[1], myself.param.ledColorRGB[2]]), function() {

                     myself.rokit.robot.drain();
                   });
                 }
                 myself.rokit.loopExit = true;
             }
           break;

           case myself.command.DCMotor:
            //pointer = pointer - 1; //not 163
             if( myself.enable.DCMotorSendEn[0] > 0 ) {
                 myself.enable.DCMotorSendEn[0]--;
                 pointer = 0;
                 if(myself.rokit.hardware == myself.board.linky) {
                   myself.rokit.robot.write(new Buffer([0xFF, 0XFF, 0x04, 0x0D, pointer + 1 , myself.param.motorDir[pointer], myself.param.motorSpeed[pointer]]), function() {
                     myself.rokit.robot.drain();
                   });
                 }
                 //console.log("DCMotor1 send: P: " + pointer + "  Sp: " + myself.param.motorSpeed[pointer] + " dir: " + myself.param.motorDir[pointer]);
                 myself.rokit.loopExit = true;
             }
             if( myself.enable.DCMotorSendEn[1] > 0 ) {
                 myself.enable.DCMotorSendEn[1]--;
                 pointer = 1;
                 if(myself.rokit.hardware == myself.board.linky) {
                   myself.rokit.robot.write(new Buffer([0xFF, 0XFF, 0x04, 0x0D, pointer + 1 , myself.param.motorDir[pointer], myself.param.motorSpeed[pointer]]), function() {
                     myself.rokit.robot.drain();
                   });
                 }
                 //  console.log("DCMotor2 send: P: " + pointer + " Sp: " + myself.param.motorSpeed[pointer] + "  dir: " + myself.param.motorDir[pointer]);
                 myself.rokit.loopExit = true;
             }
           break;

           case myself.command.buzzer :
             if( myself.enable.buzzerSendEn > 0 ) {
                 myself.enable.buzzerSendEn--;
                 if(myself.rokit.hardware == myself.board.linky) {
                    myself.rokit.robot.write(new Buffer([0xFF, 0XFF, 0x04, 0x0F, myself.param.buzzData[0], myself.param.buzzData[1], myself.param.buzzData[2]]), function() {
                      myself.rokit.robot.drain();
                    });
                  }
                  myself.rokit.loopExit = true;
              }
            break;

            case myself.command.linetracing :
              if( myself.enable.linetracingSendEn > 0 ) {
                 myself.enable.linetracingSendEn--;
                 if(myself.rokit.hardware == myself.board.linky) {
                   myself.rokit.robot.write(new Buffer([0xFF, 0XFF, 0x02, 0x10, myself.param.linetracingData[0]]), function() {
                    myself.rokit.robot.drain();
                    console.log("GO! Linetracer!");
                   });
                 }
                 myself.rokit.loopExit = true;
             }
           break;
         }

         myself.rokit.sendCounter++;
         if(myself.rokit.sendCounter >= 5)  { myself.rokit.sendCounter = 0; myself.rokit.loopExit = true; }
      }
    }, 50);
   else if(stat == false) clearInterval(myself.packetHandler.sender);
 }

 myself.connectionHandler =  function(stat) {
   var myself = this;

   if(stat == true)  myself.connectionHandler.checkData = setInterval(function() {
     myself.rokit.intervalCheck++;
     if(myself.rokit.intervalCheck%3 == 0) {
       if(myself.rokit.receivingCheck > 10) {
         //document.getElementById("msg").innerHTML = "로봇에 연결되었습니다!";
          myself.rokit.connectingStatus = myself.portStatus.successDataStreaming;
         if(myself.msg.streamingSuccessMsg == false) {
           myself.hideMessage();
           ide.inform(myself.name, localize(' Linky has been connected at port \n') + myself.rokit.robot.port);
           myself.msg.streamingSuccessMsg = true;
         }
       }
       else {
         //myself.rokit.closingMsg = "연결이 원활하지 않습니다... 연결을 해제합니다.";
         myself.rokit.connectingStatus = myself.portStatus.failedDataStreaming;
         //myself.serialPortDisconnect(myself.rokit.robot.port);
         myself.rokit.robot.close();
         myself.hideMessage();
         ide.inform(myself.name, localize('There is a problem with communication.\nIt is forced to disconnect and check the problem. \n\n') + myself.rokit.robot.port);
       }
       myself.rokit.receivingCheck = 0;
     }
   }, 1000);
   else if(stat == false) {
     myself.msg.streamingSuccessMsg = false;
     clearInterval(myself.connectionHandler.checkData);
   }
 }

 myself.isBoardReady = function() {
   var myself = this;
   console.log("portStatus: " + myself.rokit.connectingStatus);
   return ((myself.rokit.connectingStatus == myself.portStatus.tryPortConnect)||(myself.rokit.connectingStatus == myself.portStatus.successPortConnect)||(myself.rokit.connectingStatus == myself.portStatus.successDataStreaming)||(myself.rokit.connectingStatus == myself.portStatus.tryDataStreaming)||(myself.rokit.connectingStatus == myself.portStatus.failedDataStreaming));
 }

 function lockPort(port) {
  var usedPort = new Array();
  if(localStorage.getItem('usedPort') != null) { usedPort = localStorage.getItem('usedPort'); console.log(usedPort); }
  else {
    usedPort = port;
    localStorage.setItem('usedPort', usedPort);
    console.log("port lock!: "  + port);
  }
  if(usedPort.indexOf(port) == -1)  {
     usedPort = usedPort + port;
     localStorage.setItem('usedPort', usedPort);
     console.log("port lock List: "  + localStorage.getItem('usedPort'));
   }
 }

 function unlockPort(port) {
   var usedPort = new Array();
   usedPort = localStorage.getItem('usedPort');
   if (usedPort.indexOf(port) > -1) {
     console.log("in!");
     usedPort = usedPort.replace(port, "");
     localStorage.setItem('usedPort', usedPort);
     console.log("port lock List: " + localStorage.getItem('usedPort'));
   }
 }

 function isPortLocked(port) {
  var usedPort = localStorage.getItem('usedPort');
  return (usedPort.indexOf(port) > -1);
 }


 myself.attemptConnection = function() {
    if(myself.rokit.connectingStatus == myself.portStatus.waitingPortConnect) {
      var ports = world.Arduino.getSerialPorts(function(ports) {
                  // Check if there is at least one port on ports object (which for some reason was defined as an array)
        if (Object.keys(ports).length == 0) {
          ide.inform(myself.name, localize('Could not connect an device\nNo linkys found'));
           return;
        }

        else if (Object.keys(ports).length >= 1) {
          var portMenu = new MenuMorph(this, 'select a port');
          Object.keys(ports).forEach(function(each) {
              portMenu.addItem(each, function() {
               myself.serialportConnect(each);
              })
          });
          portMenu.popUpAtHand(world);
        }
    });
   }
   else {
     myself.hideMessage();
     ide.inform(myself.name, localize('There is already a linky connected to this sprite'));
   }
}

 myself.serialportConnect = function(port) {
  var myself = this;
  var errMsg = "";
  var Serialport = require('serialport');
  myself.rokit.robot = new Serialport(port, {baudRate:57600});
  myself.rokit.connectingStatus = myself.portStatus.tryPortConnect;
  myself.rokit.robot.port = port;
  myself.showMessage(localize('Connecting linky at port\n') + port);
  myself.rokit.robot.on('close', function() {
    console.log('serialport event closed');
    //myself.rokit.robot.close();
    myself.serialPortDisconnect(port);
  });

  myself.rokit.robot.on('error', function(error) {
    var errMsg = error;
    console.log('error: ' + errMsg);
    //myself.rokit.closingMsg = "연결중 에러가 발생했습니다.. 포트 연결 해제합니다";
    myself.serialPortDisconnect(port);
  });

  myself.rokit.robot.on('open', function(error) {
    console.log('serialport open!!!');
    lockPort(port);
    myself.packetHandler(true);
    myself.connectionHandler(true);
    myself.rokit.connectingStatus = myself.portStatus.successPortConnect;
    console.log("hey! " + myself.rokit.connectingStatus);
  });

  myself.rokit.robot.on('data', function(data) {
    var rData, dataNum, dataType;
    var linky ='L';
    var inventor = 'I';
    var pin, pinValues, pinStatus = false;
    rData = new Buffer(data, 'utf8');
    //console.log(rData);

    if((rData[0] == 255)&&(rData[1] == 255)) {

        myself.rokit.hardware = myself.board.linky;
        myself.rokit.receivingCheck++;

        dataNum = rData[2]; dataType = rData[3];
        if(myself.rokit.hardware == myself.board.linky) {
          if((dataType == myself.dataStatus.IRSensor)&&(rData.length == (dataNum + 3))) {
            for(var j = 0; j < 5; j++) {
              myself.rokit.readValue[j] = Math.ceil(rData[j + 4] * 4.011);
            }
          }
          else if((dataType == myself.dataStatus.volt)&&(rData.length == (dataNum + 3))) {
            myself.rokit.battery = ((rData[4] << 8 ) + rData[5]) / 100;
            myself.rokit.battery = myself.rokit.battery.toFixed(2);
          }
          else if((dataType == myself.dataStatus.etc)&&(rData.length == (dataNum + 3))) {
            myself.rokit.micInput =  Math.ceil(rData[4] * 4.011);
            myself.rokit.IRRemocon = rData[5];
            myself.rokit.version = ((rData[7] & 0b11110000) >> 4) + ((rData[7] & 0b1111) * 0.1);
            myself.rokit.version = myself.rokit.version.toFixed(1);
            //console.log(myself.rokit.version);
            if((myself.rokit.version != myself.version.linky)&&(myself.rokit.firmAlert == false)) {
              myself.rokit.firmAlert = true;  //한번만 체크 하도록
              var downLinkyFirm = localStorage.getItem("LINKYDOWN");
              if(downLinkyFirm != "NEED") {
            //    setTimeout(function() {
            //      alert("로봇의 펌웨어를 업데이트 하세요! 펌웨어가 최신의 것이 아닙니다.\r\n 로봇과의 연결을 해제하고 업데이트 버튼을 눌러주세요!");
            //    }, 2000);
              }
              else {
            //    setTimeout(function() {
            //      alert("펌웨어를 업데이트 해야 하지만 서버로부터 최신 펌웨어를 가져오지 못했습니다!");
            //    }, 2000);
              }
            }
          }
        }
     }
  });
 }

  myself.serialPortDisconnect = function(port) {
   var myself = this;
   if(myself.isBoardReady()) {
     myself.packetHandler(false);
     myself.connectionHandler(false);
     unlockPort(port);
     console.log("serialport unlock! " + port);
     myself.rokit.connectingStatus = myself.portStatus.waitingPortConnect;
     myself.rokit.receivingCheck = 0;
     myself.rokit.intervalCheck = 0;
     myself.rokit.closingMsg = "";
     myself.rokit.hardware = myself.board.nothing;
     myself.hideMessage();
     ide.inform(myself.name, localize('Linky was disconnected from port\n') + myself.rokit.robot.port);
   }
   else {
    console.log("Linky not connected!");
   }
 }

//function connectWithRobot(selectedPort) {
//   serialportConnect(selectedPort);
//   myself.rokit.connectingStatus = myself.portStatus.tryDataStreaming;
// }

  myself.disconnectFromRobot = function() {
  if(this.rokit.robot != undefined) {
     if(this.rokit.robot.isOpen() == true) {
       this.rokit.robot.close();
       console.log("serial port closing!");
     }
     else {
       myself.hideMessage();
       ide.inform(myself.name, localize('Linky is not connected'));
     }
  }
  else {
    myself.hideMessage();
    ide.inform(myself.name, localize('Linky is not connected'));
  }
 }

 myself.showMessage = function(msg) {
  if (!this.message) { this.message = new DialogBoxMorph() };

    var txt = new TextMorph(
          msg,
          this.fontSize,
          this.fontStyle,
          true,
          false,
          'center',
           null,
           null,
           MorphicPreferences.isFlat ? null : new Point(1, 1),
           new Color(255, 255, 255)
         );

  if (!this.message.key) { this.message.key = 'message' + myself.name + msg };

    this.message.labelString = myself.name;
    this.message.createLabel();
    if (msg) { this.message.addBody(txt) };
    this.message.drawNew();
    this.message.fixLayout();
    this.message.popUp(world);
    this.message.show();
}

 myself.hideMessage = function() {
  if (this.message) {
    this.message.cancel();
    this.message = null;
  }
 }

}

// Definition of a new Arduino Category

SpriteMorph.prototype.categories.push('Driving');
SpriteMorph.prototype.categories.push('Shapes');
SpriteMorph.prototype.categories.push('Screen');
SpriteMorph.prototype.categories.push('Sounds');
SpriteMorph.prototype.categories.push('Sensors');
SpriteMorph.prototype.categories.push('Lights');
SpriteMorph.prototype.blockColor['Driving'] = new Color(0, 184, 136);
SpriteMorph.prototype.blockColor['Shapes'] = new Color(51, 153, 230);
SpriteMorph.prototype.blockColor['Screen'] = new Color(73, 196, 209);
SpriteMorph.prototype.blockColor['Sounds'] = new Color(238, 67, 174);
SpriteMorph.prototype.blockColor['Sensors'] = new Color(241, 194, 50);
SpriteMorph.prototype.blockColor['Lights'] = new Color(148, 91, 214);
//SpriteMorph.prototype.categories.push('Drone');
//SpriteMorph.prototype.blockColor['Drone'] = new Color(105, 128,150);


SpriteMorph.prototype.originalInitBlocks = SpriteMorph.prototype.initBlocks;
SpriteMorph.prototype.initArduinoBlocks = function() {

    //for Zumi blocks
    this.blocks.batteryCheck =
    {
        only: SpriteMorph,
        type: 'reporter',
        category: 'Sensors',
        spec: 'bettery check',
        transpilable: true
    };

    this.blocks.readSensor =
    {
       only: SpriteMorph,
       type: 'reporter',
       category: 'Sensors',
       spec: 'sensor reading %zumiSensor',
       defaults: [null],
       transpilable: true
    };

    this.blocks.IRRemocon =
    {
      only:SpriteMorph,
      type:'reporter',
      category: 'Sensors',
      spec: 'IR Remocon',
      transpilable: true
    };

    this.blocks.eulerAngle =
    {
       only: SpriteMorph,
       type: 'reporter',
       category: 'Sensors',
       spec: 'Euler angle output %euler',
       defaults: [null],
       transpilable: true
    };

    this.blocks.timer =
    {
       only: SpriteMorph,
       type: 'reporter',
       category: 'Sensors',
       spec: 'timer',
       transpilable: true
    };

    this.blocks.zumiDCmotor =
    {
       only: SpriteMorph,
       type: 'command',
       category: 'Driving',
       spec: 'DCmotor %motorNumber speed %direction with %motorSpeed',
       defaults: [null, null, null],
       transpilable: true
    };

    this.blocks.zumiDCMove =
    {
       only: SpriteMorph,
       type: 'command',
       category: 'Driving',
       spec: 'moving to %carDirection in speed %motorSpeed',
       defaults: [null, null],
       transpilable: true
    };

    this.blocks.zumiAcrossBlock =
    {
       only: SpriteMorph,
       type: 'command',
       category: 'Driving',
       spec: '$robot across blocks %blocks',
       defaults: [null, null],
       transpilable: true
    };

    this.blocks.zumiAcrossBlock_2 =
    {
       only: SpriteMorph,
       type: 'command',
       category: 'Driving',
       spec: '$robot across blocks %blocks sensor threshold %blocks',
       defaults: [null, null],
       transpilable: true
    };

    this.blocks.zumiMoveForward =
    {
       only: SpriteMorph,
       type: 'command',
       category: 'Driving',
       spec: '$robot forward for %seconds seconds in speed %motorSpeed',
       defaults: [null, null],
       transpilable: true
    };

    this.blocks.zumiMoveBackward =
    {
       only: SpriteMorph,
       type: 'command',
       category: 'Driving',
       spec: '$robot backward for %seconds seconds in speed %motorSpeed',
       defaults: [null, null],
       transpilable: true
    };

    this.blocks.zumiTurn =
    {
       only: SpriteMorph,
       type: 'command',
       category: 'Driving',
       spec: '$robot turn to %turnDir in %deg degree',
       defaults: [null, null],
       transpilable: true
    };

    this.blocks.OLEDAnimation =
    {
      only:SpriteMorph,
      type:'command',
      category: 'Screen',
      spec: 'OLED animation %OLEDPic',
      defaults: [null],
      transpilable: true
    };

    this.blocks.OLEDOutput =
    {
      only:SpriteMorph,
      type:'command',
      category: 'Screen',
      spec: 'OLED Output %output',
      defaults: [null],
      transpilable: true
    };
    this.blocks.OLEDEyes =
    {
      only:SpriteMorph,
      type:'command',
      category: 'Screen',
      spec: 'OLED eyes %expression',
      defaults: [null],
      transpilable: true
    };

    this.blocks.LEDOnOff =
    {
      only:SpriteMorph,
      type:'command',
      category: 'Lights',
      spec: 'LEDs On/Off %LEDNum %onOff',
      defaults: [null, null],
      transpilable: true
    };

    this.blocks.zumiBuzz =
    {
       only: SpriteMorph,
       type: 'command',
       category: 'Sounds',
       spec: 'play %pitch for %duration',
       defaults: [null, null],
       transpilable: true
    };

    this.blocks.zumiMoveCircle =
    {
       only: SpriteMorph,
       type: 'command',
       category: 'Shapes',
       spec: '$robot circle %turnDir in degree %deg',
       defaults: [null, null],
       transpilable: true
    };

    // Ardui... nization?
    // Whatever, let's dumb this language down:

    this.blocks.receiveGo.transpilable = true;
    this.blocks.receiveMessage.transpilable = true;
    this.blocks.doBroadcastAndWait.transpilable = true;
    this.blocks.doWait.transpilable = true;
    this.blocks.doWaitUntil.transpilable = true;
    this.blocks.doForever.transpilable = true;
    this.blocks.doRepeat.transpilable = true;
    this.blocks.doUntil.transpilable = true;
    this.blocks.doIf.transpilable = true;
    this.blocks.doIfElse.transpilable = true;
    this.blocks.reportSum.transpilable = true;
    this.blocks.reportDifference.transpilable = true;
    this.blocks.reportProduct.transpilable = true;
    this.blocks.reportQuotient.transpilable = true;
    this.blocks.reportModulus.transpilable = true;
    this.blocks.reportRound.transpilable = true;
    this.blocks.reportMonadic.transpilable = true;
    this.blocks.reportRandom.transpilable = true;
    this.blocks.reportLessThan.transpilable = true;
    this.blocks.reportEquals.transpilable = true;
    this.blocks.reportGreaterThan.transpilable = true;
    this.blocks.reportAnd.transpilable = true;
    this.blocks.reportOr.transpilable = true;
    this.blocks.reportNot.transpilable = true;
    this.blocks.reportBoolean.transpilable = true;
    this.blocks.doSetVar.transpilable = true;
    this.blocks.doChangeVar.transpilable = true;
    this.blocks.doDeclareVariables.transpilable = true;

    StageMorph.prototype.codeMappings['delim'] = ',';
    StageMorph.prototype.codeMappings['tempvars_delim'] = ', ';
    StageMorph.prototype.codeMappings['string'] = '"<#1>"';

    StageMorph.prototype.codeMappings['receiveGo'] = 'void setup() {';
    StageMorph.prototype.codeMappings['doBroadcastAndWait'] = ' !call!<#1>();';
    StageMorph.prototype.codeMappings['receiveMessage'] = 'void <#1>() {';

    StageMorph.prototype.codeMappings['doWait'] = '  Zumi.delayForGyro(<#1>);';
    StageMorph.prototype.codeMappings['doWaitUntil'] = '  while(!<#1>){\n  }\n';
    StageMorph.prototype.codeMappings['doForever'] = '}\n\nvoid loop() {\n   Zumi.getGyro();\n <#1>\n}';
    StageMorph.prototype.codeMappings['doRepeat'] = '  for (int _var_ = 0; _var_ < <#1>; _var_++) {\n  <#2>\n  }';
    StageMorph.prototype.codeMappings['doUntil'] = '  while(!<#1>){\n  <#2>\n  }';
    StageMorph.prototype.codeMappings['doIf'] = '  if (<#1>) {\n  <#2>\n}';
    StageMorph.prototype.codeMappings['doIfElse'] = '  if (<#1>) {\n  <#2>\n} else {\n  <#3>\n}';

    StageMorph.prototype.codeMappings['reportSum'] = '(<#1> + <#2>)';
    StageMorph.prototype.codeMappings['reportDifference'] = '(<#1> - <#2>)';
    StageMorph.prototype.codeMappings['reportProduct'] = '(<#1> * <#2>)';
    StageMorph.prototype.codeMappings['reportQuotient'] = '(<#1> / <#2>)';
    StageMorph.prototype.codeMappings['reportModulus'] = '(<#1> % <#2>)';
    StageMorph.prototype.codeMappings['reportRound'] = 'round(<#1>)';
    StageMorph.prototype.codeMappings['reportMonadic'] = 'Zumi.math(<#1>,<#2>)';
    StageMorph.prototype.codeMappings['reportRandom'] = 'random(<#1>, <#2>+1)';
    StageMorph.prototype.codeMappings['reportLessThan'] = '(<#1> < <#2>)';
    StageMorph.prototype.codeMappings['reportEquals'] = '(<#1> == <#2>)';
    StageMorph.prototype.codeMappings['reportGreaterThan'] = '(<#1> > <#2>)';
    StageMorph.prototype.codeMappings['reportAnd'] = '(<#1> && <#2>)';
    StageMorph.prototype.codeMappings['reportOr'] = '(<#1> || <#2>)';
    StageMorph.prototype.codeMappings['reportNot'] = '!(<#1>)';
    StageMorph.prototype.codeMappings['reportBoolean'] = '<#1>';

    StageMorph.prototype.codeMappings['doSetVar'] = '  <#1> = <#2>;';
    StageMorph.prototype.codeMappings['doChangeVar'] = '  <#1> += <#2>;';
    StageMorph.prototype.codeMappings['doDeclareVariables'] = 'int <#1> = 0;'; // How do we deal with types? Damn types...

    StageMorph.prototype.codeMappings['zumiDCmotor'] = '  Zumi.DCMotor(<#1>, <#2>, <#3>);';
    StageMorph.prototype.codeMappings['zumiDCMove'] = '  Zumi.DCMove(<#1>, <#2>);';
    StageMorph.prototype.codeMappings['zumiAcrossBlock'] = '  Zumi.moveAcrossBlocks(<#1>);';
    StageMorph.prototype.codeMappings['zumiAcrossBlock_2'] = '  Zumi.moveAcrossBlocks(<#1>,<#2>);';
    StageMorph.prototype.codeMappings['zumiMoveForward'] = '  Zumi.moveForward(<#1>, <#2>);';
    StageMorph.prototype.codeMappings['zumiMoveBackward'] = '  Zumi.moveBackward(<#1>, <#2>);';
    StageMorph.prototype.codeMappings['zumiTurn'] = '  Zumi.moveTurn(<#1>, <#2>);';
    StageMorph.prototype.codeMappings['zumiMoveCircle'] = '  Zumi.moveCircle(<#1>, <#2>, 2);';

    StageMorph.prototype.codeMappings['OLEDAnimation'] = '  Zumi.OLEDAnimation(<#1>);';
    StageMorph.prototype.codeMappings['OLEDOutput'] = '  Zumi.OLEDOutput(<#1>);';
    StageMorph.prototype.codeMappings['OLEDEyes'] = '  Zumi.OLEDEyes(<#1>);';

    StageMorph.prototype.codeMappings['zumiBuzz'] = '  Zumi.buzzer(BUZZER_PIN, <#1>, <#2>, 10);';

    StageMorph.prototype.codeMappings['IRRemocon'] = '  Zumi.readIRreceiver()';
    StageMorph.prototype.codeMappings['batteryCheck'] = '  Zumi.checkBattery()';
    StageMorph.prototype.codeMappings['eulerAngle'] = '  Zumi.eulerAngle(<#1>)';
    StageMorph.prototype.codeMappings['readSensor'] = '  Zumi.readIR(<#1>, 1)';
    StageMorph.prototype.codeMappings['timer'] = '  millis()';

    StageMorph.prototype.codeMappings['LEDOnOff'] = '  Zumi.LEDOnOff(<#1>, <#2>);';

}

SpriteMorph.prototype.initBlocks =  function() {
    this.originalInitBlocks();
    this.initArduinoBlocks();
}

SpriteMorph.prototype.initBlocks();

// blockTemplates decorator

SpriteMorph.prototype.originalBlockTemplates = SpriteMorph.prototype.blockTemplates;
SpriteMorph.prototype.blockTemplates = function(category) {
    var myself = this;

    var blocks = myself.originalBlockTemplates(category);

    //  Button that triggers a connection attempt

    var arduinoConnectButton = new PushButtonMorph(
            null,
            function () {
                myself.attemptConnection();
            },
            'Connect linky'
            );

    //  Button that triggers a disconnection from board

    var arduinoDisconnectButton = new PushButtonMorph(
            null,
            function () {
                myself.disconnectFromRobot();
            },
            'Disconnect linky'
            );

    //  Button that triggers a disconnection from board


    var streamingOnButton = new PushButtonMorph(
            null,
            function () {
                  myself.arduino.streamingOn();
            },
            'stream On'
            );

    var streamingOffButton = new PushButtonMorph(
            null,
            function () {
                  myself.arduino.streamingOff();
            },
            'stream off'
            );

    function blockBySelector(selector) {
        var newBlock = SpriteMorph.prototype.blockForSelector(selector, true);
        newBlock.isTemplate = true;
        return newBlock;
    };

    if (category === 'Driving') {
      blocks.push('-');
      blocks.push(blockBySelector('zumiDCmotor'));
      blocks.push(blockBySelector('zumiDCMove'));
      blocks.push(blockBySelector('zumiAcrossBlock'));
      blocks.push(blockBySelector('zumiAcrossBlock_2'));
      blocks.push(blockBySelector('zumiMoveForward'));
      blocks.push(blockBySelector('zumiMoveBackward'));
      blocks.push(blockBySelector('zumiTurn'));
    };

    if (category === 'Shapes') {
      blocks.push('-');
      blocks.push(blockBySelector('zumiMoveCircle'));
    };

    if (category === 'Screen') {
      blocks.push('-');
      blocks.push(blockBySelector('OLEDAnimation'));
      blocks.push(blockBySelector('OLEDOutput'));
      //blocks.push(blockBySelector('OLEDEyes'));
    };

    if (category === 'Sounds') {
      blocks.push('-');
      blocks.push(blockBySelector('zumiBuzz'));
    };

    if (category === 'Sensors') {
      blocks.push('-');
      blocks.push(blockBySelector('timer'));
      blocks.push(blockBySelector('IRRemocon'));
      blocks.push(blockBySelector('batteryCheck'));
      blocks.push('-');
      blocks.push(blockBySelector('readSensor'));
      blocks.push(blockBySelector('eulerAngle'));
    };

    if (category === 'Lights') {
      blocks.push('-');
      blocks.push(blockBySelector('LEDOnOff'));
    };

    return blocks;
}
