﻿/*
	IOT.h - IOT library
	Copyright (C) 2014 RoboLink.  All rights reserved.
	LastUpdate : 2020-06-24
*/

#ifndef IOT_h
#define IOT_h
#include "Arduino.h"
#include "IOT_Util.h"
#include "IOT_Sounds.h"
#include "IOT_LED.h"
#include "IOT_Gyro.h"
#include "IOT_Drone.h"

#include <avr/interrupt.h>
#include <EEPROM.h>
#include <SoftwareSerial.h>
#include <TimerOne.h>
//------------------------------------------------------------------------------------//


//------------------------------------------------------------------------------------//
#define RF_BAUDRATE 57600

#define SOFT_SERIAL	softSerial
#define MAIN_SERIAL	Serial


#define MAX_PACKET_LENGTH 50              //80


//#define SERIAL0  0
//#define SERIAL1 1

//------------------------------------------------------------------------------------//


#define BUT_L 13
#define BUT_R 11

#define BUT_D 7
#define BUT_U 12

#define MIC_PIN A6
#define BAT_PIN A7

//------------------------------------------------------------------------------------//


#define BUTTON       1
#define GYRO         2
#define JOYSTICK_L   3
#define JOYSTICK_R   4
#define JOYSTICK_ALL 5
#define MAIN_BOARD   6

//------------------------------------------------------------------------------------//



//------------------------------------------------------------------------------------//
//BT

#define BT_BAUDRATE 9600

#define BT_UP       0x10
#define BT_DOWN     0x40
#define BT_LEFT     0x80
#define BT_RIGHT    0x20

#define BT_BUT_R1   0x08
#define BT_BUT_R2   0x02
#define BT_BUT_L1   0x04
#define BT_BUT_L2   0x01

//------------------------------------------------------------------------------------//
//ROKIT_BRICK

#define UP     0x01
#define DOWN   0x02
#define LEFT   0x03
#define LEFT_  0x03
#define RIGHT  0x04
#define RIGHT_ 0x04

#define VALUE_X  0x01
#define VALUE_Y  0x02

#define ON       0x01
#define OFF      0x00

#define COLOR_WIPE			  0x00
#define RAINBOW               0x01
#define RAINBOW_CYCLE         0x02
#define THEATER_CHASE         0x03
#define THEATER_CHASE_RAINBOW 0x04

#define WHOLE_NOTE   1000
#define HALF_NOTE     500
#define QUARTER_NOTE  250
#define EIGHTH_NOTE   125
#define SIXTEENTH_NOTE 62

#define FIRE_BALL  0x00
#define COIN       0x01
#define UP1        0x02
#define BEEP1      0x03
#define BEEP2      0x04
#define SOUND_1    0x05
#define SOUND_2    0x06
#define SOUND_3    0x07
#define SOUND_4    0x08
#define CHARGING   0x09

#define JOYSTICK_ALL 0x01
#define GYRO         0x02

#define START_EVENT     0x10
#define SUCCESS_EVENT   0x11
#define FAIL_EVENT      0x12
#define SCORE_EVENT     0x20
#define SHOOT_EVENT     0x21
#define COLLISION_EVENT 0x22
#define NONE_EVENT      0x00

#define MAIN  0x01


//------------------------------------------------------------------------------------//

void initailzie();

//int BootDisplay();
int ProgramSelection(int mode);
//------------------------------------------------------------------------------------//



//------------------------------------------------------------------------------------//

void CodroneMiniControl(int mode);

void GyroDisplay_CoDrone(int all, int fb, int lr);
//int GyroAngleDisplay();

void HandModules_Test();
//void GyroAngleSend();

void GyroGlove();
void GyroHandlebars();
int GyroShake();
int GyroShakeCheck();
void GyroFishingRod();

void AllSend(byte mic);

void Simulator_Check();
void actionPlay(void);
void blinkLED(void);
void RFModuleReceive_softserial();

void RFModuleReceive();
//void ReceiveProcess(byte input);
void ReceiveProcess(byte input, byte sendSerial);

//for Rokitbrick CG mode
void WR_initialize();
bool WR_buttonInput(int btn);
int WR_leftJoystickInput(int axis);
int WR_rightJoystickInput(int axis);
int WR_MICInput();
int WR_checkBattery();
int WR_eulerAngle(int euler);

void WR_serialPrint(int dev);
void WR_actionPlayOutput();

void WR_controlObject(int num);

//void WR_mainLED(int num, int clr, bool onoff);
//void WR_leftLED(int num, int clr, bool onoff);
//void WR_rightLED(int num, int clr, bool onoff);

void WR_LEDBrightControl(uint8_t board, uint8_t ledNum, uint8_t bright, bool onoff);
void WR_LEDRGBControl(uint8_t board, uint8_t ledNum, int clr, bool onoff);
void WR_LEDRGBSet(uint8_t board, uint8_t ledNum, uint8_t red, uint8_t green, uint8_t blue, bool onoff);
void WR_allLEDClear(int _board);

void WR_LEDAnimation(int num, float wait);

void WR_playNote(int pitch, int dur);

void WR_soundEffect(int num);
void WR_delay(float tm);

int rgba(uint8_t red, uint8_t green, uint8_t blue, uint8_t alpha);

bool WR_actionPlayEvent(uint8_t _event);

#endif