Process.prototype.exData = function() {
  exServoPin : undefined;
  exServoValue = undefined;
  exAnalogPin = undefined;
  exAnalogValue = undefined;
  exDigitalPin  = undefined;
  exDigitalValue = undefined;
  exDigitalInputValue = undefined;
  exMotorPin = undefined;
  exMotorDir = undefined;
  exMotorSpeed = undefined;
  sevenSensorValue = undefined;
  batteryRemnant = undefined;
  //exIRRemoconValue = 0xFF;
};

Process.prototype.packetTable = {
  setServo : int = 0,
  setAnalogPin : int = 1,
  setDigitalPin : int = 2,
  setDCMotor  : int = 3,
  setDigitalReading : int = 4,
  sevenSensor : int = 5,

  enableNum_1 : int = 1,
  enableNum_2 : int = 2,
  enableNum_3 : int = 3,
  enableNum_4 : int = 4,
  enableNum_5 : int = 5,
}

Process.prototype.inputDataInit = function() {
  var myself = this;

  myself.exData.exDigitalInputValue = {};

  for(var i = 0; i < 32; i++) {
    myself.exData.exDigitalInputValue[i] = true;        // pin input status (HIGH/LOW)

  }
}

Process.prototype.exDataInit = function() {
  var myself = this;

  myself.exData.exServoValue = {};
  myself.exData.exAnalogValue = {};
  myself.exData.exDigitalPin = {};
  myself.exData.exDigitalValue = {};
  myself.exData.exMotorDir = {};
  myself.exData.exMotorSpeed = {};


  for(var i = 0; i < 32; i++) {
    myself.exData.exServoValue[i] = 200;
    myself.exData.exAnalogValue[i] = -1;
    myself.exData.exDigitalPin[i] =  true;              // pin mode (INPUT/OUPUT)
    myself.exData.exDigitalValue[i] = -1;             // pin write (HIGH/LOW)
    myself.exData.exMotorDir[i] = -1;
    myself.exData.exMotorSpeed[i] = -1;
  }
  myself.exData.sevenSensorValue = false;
  myself.exData.batteryRemnant = -1;
}


Process.prototype.sendData = function () {
    var myself = this;
    var sprite = this.homeContext.receiver;
    var buffer = new Buffer(10);
    var same = true;
    var i = 0;
    var checksum = 0;

    if (sprite.arduino.isBoardReady()) {

    //for( i = 0; i < 10; i++)  buffer[i] = sprite.arduino.board.dronePacket[i];
      for( i = 0; i < 10; i++)  buffer.writeInt8(sprite.arduino.board.dronePacket[i],i);

      for(i = 4; i < 9; i++ ) {
        if(sprite.arduino.board.dronePacket[i] != sprite.arduino.board.exDronePacket[i]) same = false;
      }

      if(same == false) {
        for( i = 2; i < 9; i++)  checksum = checksum + buffer[i];
        buffer[9] = checksum;

        sprite.arduino.board.write( buffer, function() {
          sprite.arduino.board.drain();
        });

        console.log(sprite.arduino.board.dronePacket[4]+" "+sprite.arduino.board.dronePacket[5]+" "+sprite.arduino.board.dronePacket[6]+" "+sprite.arduino.board.dronePacket[7]+" "+sprite.arduino.board.dronePacket[8]+" "+ checksum);
      }

      for( i = 0; i < 10; i++)  sprite.arduino.board.exDronePacket[i] = sprite.arduino.board.dronePacket[i];

      if(sprite.arduino.board.dronePacket[8] == -79 || sprite.arduino.board.dronePacket[8] == -95) {
        sprite.arduino.board.dronePacket[4] = 0x00;
        sprite.arduino.board.dronePacket[5] = 0x00;
        sprite.arduino.board.dronePacket[6] = 0x00;
        sprite.arduino.board.dronePacket[7] = 0x00;
      }

      sprite.arduino.board.dronePacket[8] = 0x00;

    } else {
        throw new Error(localize("Board not connected"));
    }
}

Process.prototype.throttle = function (pin) {
    var sprite = this.homeContext.receiver;

    if (sprite.arduino.isBoardReady()) {

      if(pin >= 100)  sprite.arduino.board.dronePacket[7] = 100;
      else if(pin <= - 100)  sprite.arduino.board.dronePacket[7] = -100;
      else sprite.arduino.board.dronePacket[7] = pin;

    } else {
        throw new Error(localize("Board not connected"));
    }
}

Process.prototype.yaw = function (pin) {
    var sprite = this.homeContext.receiver;

    if (sprite.arduino.isBoardReady()) {

      if(pin >= 100)  sprite.arduino.board.dronePacket[6] = 100;
      else if(pin <= - 100)  sprite.arduino.board.dronePacket[6] = -100;
      else sprite.arduino.board.dronePacket[6] = pin;

    } else {
        throw new Error(localize("Board not connected"));
    }
}

Process.prototype.roll = function (pin) {
    var sprite = this.homeContext.receiver;

    if (sprite.arduino.isBoardReady()) {

      if(pin >= 100)  sprite.arduino.board.dronePacket[4] = 100;
      else if(pin <= - 100)  sprite.arduino.board.dronePacket[4] = -100;
      else sprite.arduino.board.dronePacket[4] = pin;

    } else {
        throw new Error(localize("Board not connected"));
    }
}

Process.prototype.pitch = function (pin) {
    var sprite = this.homeContext.receiver;

    if (sprite.arduino.isBoardReady()) {

      if(pin >= 100)  sprite.arduino.board.dronePacket[5] = 100;
      else if(pin <= - 100)  sprite.arduino.board.dronePacket[5] = -100;
      else sprite.arduino.board.dronePacket[5] = pin;

    } else {
        throw new Error(localize("Board not connected"));
    }
}

Process.prototype.pushEvent = function (mode) {
    var sprite = this.homeContext.receiver;

    if (sprite.arduino.isBoardReady()) {
      var val = new Int8Array(1);

      switch(mode[0]) {
          case 'STOP': val[0] = 0xA1; break;
          case 'RESET_YAW': val[0] = 0xB1; break;
          case 'ABSOLUTE_MODE': val[0] = 0xE0; break;
          case 'NORMAL_MODE': val[0] = 0xE1; break;
          case 'PAIRING': val[0] = 0xB2; break;
       }

      sprite.arduino.board.dronePacket[8] = val[0];
      //console.log(sprite.arduino.board.dronePacket[8]);
      //console.log(val[0]);

    } else {
        throw new Error(localize("Board not connected"));
    }
}

Process.prototype.pushTrim = function (mode) {
    var sprite = this.homeContext.receiver;

    if (sprite.arduino.isBoardReady()) {
      var val = new Int8Array(1);

      switch(mode[0]) {
          case 'RESET': val[0] = 0x80; break;
          case 'PITCH_INCREASE': val[0] = 0x81; break;
          case 'PITCH_DECREASE': val[0] = 0x82; break;
          case 'YAW_INCREASE': val[0] = 0x83; break;
          case 'YAW_DECREASE': val[0] = 0x84; break;
          case 'ROLL_INCREASE': val[0] = 0x86; break;
          case 'ROLL_DECREASE': val[0] = 0x85; break;
        }

      sprite.arduino.board.dronePacket[8] = val[0];
      //console.log(sprite.arduino.board.dronePacket[8]);
      //console.log(val[0]);

    } else {
        throw new Error(localize("Board not connected"));
    }
}


Process.prototype.setServo = function (pin, value) {
    var sprite = this.homeContext.receiver;
    var myself = this;

    if (sprite.arduino.isBoardReady()) {
  //    if( myself.exData.exServoValue[pin] != value) {

        sprite.packetTable.setServoSendEn[pin] = myself.packetTable.enableNum_1;
        myself.exData.exDigitalPin[pin] = true;
        myself.exData.exServoValue[pin] = value;
  //    }

    } else {
        throw new Error(localize("Board not connected"));
    }
}

Process.prototype.setAnalogPin = function (pin,value) {
    var sprite = this.homeContext.receiver;
    var myself = this;

    if (sprite.arduino.isBoardReady()) {
      if(value >= 255) value = 255;
      else if(value <= 0) value = 0;

  //    if(myself.exData.exAnalogValue[pin] != value) {
        sprite.packetTable.setAnalogPinSendEn[pin] = myself.packetTable.enableNum_1;
        myself.exData.exDigitalPin[pin] = true;
        myself.exData.exAnalogValue[pin] = value;
          //world.Arduino.sleep(30);
//      }
      //console.log("pin:"+pin+"value:"+booleanValue);

    } else {
        throw new Error(localize("Board not connected"));
    }
}

Process.prototype.setDigitalPin = function (pin, booleanValue) {
    var sprite = this.homeContext.receiver;
    var myself = this;

    if (sprite.arduino.isBoardReady()) {
//      if(myself.exData.exDigitalValue[pin] != booleanValue) {
         sprite.packetTable.setDigitalPinSendEn[pin] = myself.packetTable.enableNum_1;

         if((pin >= 11)&&(pin <= 18)) myself.exData.sevenSensorValue = false;
         myself.exData.exDigitalPin[pin] = true;
         myself.exData.exDigitalValue[pin] = booleanValue;
//      }
    }
     else {
        throw new Error(localize("Board not connected"));
    }
}

Process.prototype.setDCmotor = function (num, speed, dir) {
    var sprite = this.homeContext.receiver;
    var myself = this;
    var motorNumber = 0;
    var direction = 0;

    if (sprite.arduino.isBoardReady()) {

      switch(num[0]) {
          case 'M1': motorNumber = 1; break;
          case 'M2': motorNumber = 2; break;
      }
      switch(dir[0]) {
          case 'CW': direction = 1; break;
          case 'CCW': direction = 2; break;
          case 'STOP': direction = 3; break;
          case 'LOOSE': direction = 4; break;
      }
    //  if ((myself.exData.exMotorDir[num] != direction)||(myself.exData.exMotorSpeed[num] != speed)) {
          sprite.packetTable.setDCMotorSendEn[motorNumber] = myself.packetTable.enableNum_1;

          myself.exData.exMotorDir[motorNumber] = direction;
          myself.exData.exMotorSpeed[motorNumber] = speed;
  //   }
    } else {
        throw new Error(localize("Board not connected"));
    }
}

Process.prototype.setTone = function (num, speed, dir) {
    var sprite = this.homeContext.receiver;
    var myself = this;
    var motorNumber = 0;
    var direction = 0;

    if (sprite.arduino.isBoardReady()) {


    } else {
        throw new Error(localize("Board not connected"));
    }
}

Process.prototype.analogReading = function (pin) {
    var sprite = this.homeContext.receiver;
    //console.log("SPRITE: " + sprite);
    if (sprite.arduino.isBoardReady()) {

        if(sprite.arduino.board.dataReady[pin - 19] == true){
          //sprite.arduino.board.dataReady[pin - 19] = false;
          return sprite.arduino.board.readValue[pin - 19];
        }
        else {
        //console.log("value:" + sprite.arduino.board.readValue[pin - 19] + " zero:" +sprite.arduino.board.dataReady[pin - 19] );
        return 0;

        }
    } else {
        throw new Error(localize("Board not connected"));
    }
}

Process.prototype.digitalReading = function (pin) {
    var myself = this;
    var sprite = this.homeContext.receiver;
    var pinStatus;
    if (sprite.arduino.isBoardReady()) {
  //       if(myself.exData.exDigitalPin[pin] == true) {
           myself.exData.exDigitalPin[pin] = false;
           sprite.packetTable.digitalReadingSendEn[pin] = myself.packetTable.enableNum_1;
  //      }

      pinStatus = myself.exData.exDigitalInputValue[pin];

      return pinStatus;

    } else {
        throw new Error(localize("Board not connected"));
    }
}

Process.prototype.sevenSensor = function () {
    var sprite = this.homeContext.receiver;
    var myself = this;

    if (sprite.arduino.isBoardReady()) {
      console.log("sevenbool: "+ myself.exData.sevenSensorValue );
//      if((myself.exData.sevenSensorValue == false)||(myself.exData.sevenSensorValue == undefined)) {
        sprite.packetTable.sevenSensorSendEn = myself.packetTable.enableNum_1;

//      }
      var sensorValue = sprite.arduino.board.readValue[10];
      if(sprite.arduino.board.dataReady[10] == true){
        //sprite.arduino.board.dataReady[10] = false;
        sensorValue = sensorValue & 0x00FF;

        return sensorValue;
      }
      else {
       return 0;
      }
    } else {
        throw new Error(localize("Board not connected"));
    }
}

Process.prototype.IRRemocon = function () {
    var sprite = this.homeContext.receiver;

    if (sprite.arduino.isBoardReady()) {
        var IRValue = sprite.arduino.board.readValue[10];
        if(sprite.arduino.board.dataReady[10] == true){
          //sprite.arduino.board.dataReady[10] = false;
          IRValue = (IRValue & 0xFF00) >> 8;

          return IRValue;
        }
        else {
        //console.log("value:" + sprite.arduino.board.readValue[pin - 19] + " zero:" +sprite.arduino.board.dataReady[pin - 19] );
        return 0;

        }
    } else {
        throw new Error(localize("Board not connected"));
    }
}
